//*************************************************************************************************
//
//	Description:
//		overdraw_viz.fx - Shader for rendering overdraw visualisation.
//
//	<P> Copyright (c) 2007 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Tom Nettleship
//
//	History:
//
//	<TABLE>
//		\Author         Date        Version       Description
//		--------        -----       --------      ------------
//		TNettleship     01/18/2008  0.1           Created
//	<TABLE>
//
//*************************************************************************************************

#include "stddefs.fxh"

//-----------------------------------------------------------------------
//
// Input parameters
//

#if defined( _3DSMAX_ ) || defined(USE_WVP_CONSTANT)
// Max doesn't support viewproj as an app-supplied parameter
float4x4 worldviewproj : WorldViewProjection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
>;
#else
SHARE_PARAM float4x4 viewproj : ViewProjection
<
	bool appEdit = false;
	bool export = false;
>;
#endif

float4x4 world : World
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
	bool dynamic = true;
>;


//-----------------------------------------------------------------------
//
// Vertex Shader
//

// Input structure
struct VSINPUT
{
	float3 position : POSITION;													// Object space position
};

// Output structures
struct VSOUTPUT
{
	float4 position		: POSITION;													// View-coords position
};



VSOUTPUT OverdrawVertexShader( float3 pos : POSITION )
{
	VSOUTPUT _output;

#if !defined( _3DSMAX_ ) && !defined(USE_WVP_CONSTANT)
	float4x4	worldviewproj = mul( world, viewproj );
#endif

	// Calculate clip-space position of the vertex
	_output.position = mul( float4( pos, 1.0f ), worldviewproj );

	return _output;
}



//-----------------------------------------------------------------------
//
// Fragment Shaders
//

float4 OverdrawFragmentShader() : COLOR0
{
	// Show depth complexity up to 20 before clipping
	return 0.05f;
}



//-----------------------------------------------------------------------
//
// Technique(s)
//

technique Overdraw
<
	bool supportsSpecialisedLighting = false;
  bool preservesGlobalState = true;
	string normalBehaviour	= "ERMB_RENDER";
	string normalTechnique	= "Overdraw";
	int    normalDeferredID	= 0;
>
{
	pass Pass0
#ifdef _3DSMAX_
	<
		bool	ZEnable = false;
		bool	ZWriteEnable = false;
		bool	AlphaBlendEnable = true;
		string SrcBlend = "ONE";
		string DestBlend = "ONE";
		string BlendOp = "ADD";
	>
#endif
	{
#ifdef _3DSMAX_
		ZEnable = false;
		ZWriteEnable = false;
		AlphaBlendEnable = true;
		SrcBlend = ONE;
		DestBlend = ONE;
		BlendOp = ADD;
#endif

#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx OverdrawVertexShader();
		PixelShader = compile sce_fp_rsx OverdrawFragmentShader();
#else
		VertexShader = compile vs_3_0 OverdrawVertexShader();
		PixelShader = compile ps_3_0 OverdrawFragmentShader();
#endif
	}
}
